//								EJEMPLO 33
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Los mdulos CCPx. Modo PWM. Modulacin de anchura de pulsos.
//
//Consiste en generar una seal de onda cuadrada por la lnea RC2/CCP1 cuyo periodo puede
//ser modificado as como la anchura del pulso (Duty Cycle). El periodo se determina segn la 
//frmula T=(PR2+1)*4*Tosc*TMR2 preescaler. La duracin del pulso o "Duty Cycle" (d) se deter-
//mina segn d=(CCPR1L:CCPCON1<5:4>)*Tosc*TMR2 preescaler.
//
//El ejemplo emplea al mdulo CCP1 con salida de seal por la lnea RC2/CCP1 y un preescaler 
//de 16. La seal de salida tiene un periodo de 3200 uS. La anchura del ciclo "Duty"  es variable
//y, se determina, segn el valor binario de los interruptores del entrenador  (RA5-RA0)

	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (C)
#use delay(clock=4000000)

int	periodo=200		;//Periodo de 3200 uS (200* 16 * 1)

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_c(0x00);				//Borra las salidas
	set_tris_a(0xff);			//Puerta A entradas
	set_tris_c(0xb1111011);		//RC2 salida

//El mdulo CCP1 acta en el modo PWM con salida de seal por RC2/CCP1

	setup_ccp1(CCP_PWM);	//Modo PWM para el CCP1
	
//El TMR2 trabaja con un preescaler 1:16 por lo que con una frecuencia de 4MHz evoluciona
//cada 16uS ((4*Tosc)*16)

	setup_timer_2(T2_DIV_BY_16,periodo-1,1);	//Carga el periodo y TMR2 en ON

	while(1)
	{	
	CCP_1_LOW=(input_a()& 0b00111111);	//Lee RA0-RA5 y establece el duty
	}
}	
